%Kubatura transzformacioval, pelda

clear; clc;

Gaussp_x = load('./Gaussp_x.txt'); Gausss = load('./Gausss.txt');
Gaussp_y=load('./Gaussp_y.txt');

%Teglalap megadasa a koordinataival
x = [6 10 10 6];
y = [-3 -3 3 3]; I = 0;

for o = 1:length(Gaussp_x)
for p = 1:length(Gaussp_y)
    
N_1 = 0.25*(1-Gaussp_x(p))*(1-Gaussp_y(o));
N_2 = 0.25*(1+Gaussp_x(p))*(1-Gaussp_y(o));
N_3 = 0.25*(1+Gaussp_x(p))*(1+Gaussp_y(o));
N_4 = 0.25*(1-Gaussp_x(p))*(1+Gaussp_y(o));

P = x(1)*N_1+x(2)*N_2+x(3)*N_3+x(4)*N_4;
Q = y(1)*N_1+y(2)*N_2+y(3)*N_3+y(4)*N_4;

dx_dkszi = 0.25*x(1)*(-1+Gaussp_y(o)) + 0.25*x(2)*(1-Gaussp_y(o)) + ...
0.25*x(3)*(1+Gaussp_y(o)) + 0.25*x(4)*(-1-Gaussp_y(o));

dx_deta = 0.25*x(1)*(-1+Gaussp_x(p)) + 0.25*x(2)*(-1-Gaussp_x(p)) + ...
0.25*x(3)*(1+Gaussp_x(p)) + 0.25*x(4)*(1-Gaussp_x(p));

dy_dkszi = 0.25*y(1)*(-1+Gaussp_y(o)) + 0.25*y(2)*(1-Gaussp_y(o)) + ...
0.25*y(3)*(1+Gaussp_y(o)) + 0.25*y(4)*(-1-Gaussp_y(o));

dy_deta = 0.25*y(1)*(-1+Gaussp_x(p)) + 0.25*y(2)*(-1-Gaussp_x(p)) + ...
0.25*y(3)*(1+Gaussp_x(p)) + 0.25*y(4)*(1-Gaussp_x(p));

det_jacobi = dx_dkszi*dy_deta - dy_dkszi*dx_deta;

I = I + Gausss(o)*Gausss(p)* 1/sqrt(P^2+Q^2) * abs(det_jacobi);

end
end