/////////////////////////////////////////
// Linear antenna array simulation
// Andras Nemeth
// bandi@beer.com
// CLASS AntennaCanvas
/////////////////////////////////////////


package antenna;

import java.net.*;
import java.applet.*;
import java.awt.*;
import java.awt.event.*;


class AntennaCanvas extends Canvas implements MouseMotionListener

{
    Antenna parent;
    double phase;
    double dist;
    double n;
    double r[] = new double[ 180 ];
    int x[] = new int[ 181 ];
    int y[] = new int[ 181 ];



AntennaCanvas( Antenna applet )
    {
        parent = applet;
	addMouseMotionListener(this);

    }
    
private double f( int degree )
    {
        double result;
        double sina = Math.sin( degree * Math.PI / 180.0 );
        double x    = ( dist * sina + phase ) / 2.0;
        
        try
        {
            result = Math.abs( Math.sin( n * x ) / Math.sin( x ) );
        }
        catch ( ArithmeticException ae )
        {
            result = 0.0;
        }
        
        return result;
    }
    
public void paint( Graphics g )
    {
        int i;
        g.setColor( Color.lightGray );
        g.fillRect( 0, 0, parent.x_dim, parent.y_dim );
        g.setColor(new Color(180,140,140));



/// Draws the grid background
/*        for ( i = 0; i <= parent.x_dim; i += 20 )
            g.drawLine( i, 0, i, parent.y_dim );
       
        for ( i = 0; i <= parent.y_dim; i += 20 )
            g.drawLine( 0, i, parent.x_dim, i );
*/



// Draws the background image
	Image patternImage = parent.getImage(parent.getDocumentBase(), "pattern.gif");
	g.drawImage(patternImage, -19, -30,this) ;



        n     = parent.sb_number.getValue();
        dist  = 2.0 * Math.PI * parent.sb_distance.getValue() / 100.0;
        phase = parent.sb_phase.getValue() * Math.PI / 180.0;

        for ( i = 0; i <= 179; i++ )
            r[ i ] = f( i * 2 + 1 );
        
        scale();
        
        for ( i = 0; i <= 179; i++ )
        {
            double angle = ( ( double ) ( i * 2 + 1 ) ) * Math.PI / 180.0;
            int xs = parent.x_dim / 2;
            int ys = parent.y_dim / 2;
            
            x[ i ] = ( int ) ( r[ i ] * Math.cos( angle ) * xs ) + xs;
            y[ i ] = ( int ) ( ys - ( r[ i ] * Math.sin( angle ) * ys ) );
        }

        x[ 180 ] = x[ 0 ];
        y[ 180 ] = y[ 0 ];
        
        g.setColor( Color.blue );
        g.drawPolygon( x, y, x.length );

	elementDraw( g,n,parent.sb_distance.getValue() / 10 );

	g.drawLine(150,150, parent.mouseX, parent.mouseY);

    }
    
private void scale()
    {
        double max = 0.0;
        int i;

        for ( i = 0; i <= 179; i++ )
            if ( r[ i ] > max )
                max = r[ i ];
        
        
        for ( i = 0; i <= 179; i++ )
            r[ i ] /= max;
    }


//We Draw all the elements

public void elementDraw( Graphics g, double n, double dist )
	{

        	g.setColor( Color.red );

		for (int k = 0; k < n; k++)
		{

		 int yPos = 148-(int)((n-1)*(dist+10)/2)+(int)(k*(dist+10));
	         g.fillOval( 148, yPos , 6, 6 ) ;

	   	}

	}


public void destroy()
	{
	removeMouseMotionListener( this );
	}


public void mouseMoved( MouseEvent e )
	{

	}

public void mouseDragged( MouseEvent e )
	{
		
		parent.mouseX = e.getX();
		parent.mouseY = e.getY();
		double xPos = e.getX()-150;
		double yPos = 150-e.getY();
		double result = Math.atan( yPos/xPos );
		double amplitude = 0;
		result = ( 180.0*result/Math.PI );
		
		

		if( xPos < 0 && yPos >= 0 )
			{
			result = ( result ) + 180;
			}

		if( xPos >= 0 && yPos<0 )

			{
			result = result + 360;
			}



		if( xPos < 0 && yPos < 0 )
			{
			result = Math.abs( result ) + 180;
			}



		amplitude = (int)(Math.sqrt((150-x[(int)(result/2)])*(150-x[(int)(result/2)])
				+(y[(int)(result/2)]-150)*(y[(int)(result/2)]-150)));
			
		amplitude = ( 10*Math.log( amplitude / 149.0 ));
		String amplitudeString = Double.toString( amplitude );

		parent.positionLabel.setText( "" + (int)result + " degrees"  +  "  Amplitude:"+
		 amplitudeString.substring( 0,amplitudeString.length() / 3 ) + " dB" );		

		if (amplitudeString.startsWith("-In") )
		{

		parent.positionLabel.setText( "" + (int)result + " degrees"  +  "  Amplitude:"+
		 amplitudeString + " dB" );		
		}


	/*	if ((Math.abs( xPos ) > 147)| (Math.abs( yPos ) > 147))
		{
		parent.positionLabel.setText( "" );
		}
	*/


		repaint();
	}


}
