/////////////////////////////////////////
// Linear antenna array simulation
// Andras Nemeth
// bandi@beer.com
// CLASS Antenna
/////////////////////////////////////////

package antenna;

import java.net.*;
import java.applet.*;
import java.awt.*;
import java.awt.event.*;

public class Antenna extends java.applet.Applet

{
    final int x_dim = 300;
    final int y_dim = 300;
    AntennaCanvas graph;
    Label d_number;
    Label d_distance;
    Label d_phase;
    Label v_number;
    Label v_distance;
    Label v_phase;
    Label positionLabel;
    Scrollbar sb_number;
    Scrollbar sb_distance;
    Scrollbar sb_phase;
    int mouseX = 150;
    int mouseY = 150;
	
    
    public void init()
    {

        setLayout( null );

        graph = new AntennaCanvas( this );
        graph.setBounds( 0, 0, x_dim, y_dim );
        add( graph );
        
        d_number = new Label( "number of elements" );
        d_number.setBounds( x_dim + 10, 30, 160, 20 );
        add( d_number );
        
        d_distance = new Label( "distance in lambda" );
        d_distance.setBounds( x_dim + 10, 90, 160, 20 );
        add( d_distance );
        
        d_phase = new Label( "phase shift" );
        d_phase.setBounds( x_dim + 10, 150, 160, 20 );
        add( d_phase );
        
        v_number = new Label( "" );
        v_number.setBounds( x_dim + 380, 30, 100, 20 );
        add( v_number );
        
        v_distance = new Label( "" );
        v_distance.setBounds( x_dim + 380, 90, 100, 20 );
        add( v_distance );
        
        v_phase = new Label( "" );
        v_phase.setBounds( x_dim + 380, 150, 100, 20 );
        add( v_phase );

        positionLabel = new Label( "Drag the mouse on the pattern" );
        positionLabel.setBounds( x_dim + 10, 200, 200, 20 );
        add( positionLabel );
       
        sb_number = new Scrollbar( Scrollbar.HORIZONTAL, 2, 0, 2, 16 );
        sb_number.addAdjustmentListener( new ScrollbarListener( 1, v_number, graph ) );
        sb_number.setUnitIncrement( 1 );
        sb_number.setBlockIncrement( 2 );
        sb_number.setBounds( x_dim + 180, 30, 200, 20 );
        add( sb_number );
        
        sb_distance = new Scrollbar( Scrollbar.HORIZONTAL, 50, 0, 1, 200 );
        sb_distance.addAdjustmentListener( new ScrollbarListener( 2, v_distance, graph ) );
        sb_distance.setUnitIncrement( 1 );
        sb_distance.setBlockIncrement( 5 );
        sb_distance.setBounds( x_dim + 180, 90, 200, 20 );
        add( sb_distance );
        
        sb_phase = new Scrollbar( Scrollbar.HORIZONTAL, 0, 0, -180, 181 );
        sb_phase.addAdjustmentListener( new ScrollbarListener( 3, v_phase, graph ) );
        sb_phase.setUnitIncrement( 1 );
        sb_phase.setBlockIncrement( 20 );
        sb_phase.setBounds( x_dim + 180, 150, 200, 20 );
        add( sb_phase );
        
        v_number.setText( String.valueOf( sb_number.getValue() ) );
        v_distance.setText( String.valueOf( sb_distance.getValue() / 100.0 ) );
        v_phase.setText( String.valueOf( sb_phase.getValue() ) );


        repaint();

    }

    public void paint( Graphics g )
    {
        graph.paint( g );
    }


   public String getAppletInfo()
   {  return "Antenna Array simulation program \n"
	 +"Author: Andras Nemeth \t <bandi@beer.com>\n"
         +"http://w3.swi.hu/neandras\t"
	 +" 14. november 2000.";
   }

}
