/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;

public class Simulation
extends Applet
implements Runnable {
    static final String TO_EXP1 = "Go to part 1";
    static final String TO_EXP2 = "Go to part 2";
    static final String TO_EXP3 = "Go to part 3";
    String expNumber;
    Button changeExp;
    Oscilloscope scope;
    Circuit circuit;
    Panel mainPanel;
    Panel buttonPanel;
    Image imgScope;
    Image imgCircuit;
    MediaTracker tracker;
    Thread getImages;
    String message;

    public void init() {
        this.setBackground(Color.white);
        this.expNumber = this.getParameter("experiment");
        this.tracker = new MediaTracker(this);
        this.imgCircuit = this.getImage(this.getCodeBase(), this.getParameter("circuit"));
        this.imgScope = this.getImage(this.getCodeBase(), this.getParameter("oscilloscope"));
        this.tracker.addImage(this.imgCircuit, 0);
        this.tracker.addImage(this.imgScope, 0);
        this.tracker.checkAll(true);
    }

    public void start() {
        System.out.println("Start entered");
        if (this.getImages == null) {
            this.getImages = new Thread(this);
            this.getImages.start();
        }
    }

    public void stop() {
        System.out.println("Stop entered");
        if (this.getImages != null) {
            this.getImages.stop();
            this.getImages = null;
        }
    }

    public void run() {
        this.message = "Loading images";
        this.repaint();
        System.out.println(this.tracker.checkID(0));
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Error loading images");
            this.message = "Error loading images";
            this.imgCircuit = null;
            this.imgScope = null;
        }
        if (this.tracker.isErrorID(0)) {
            System.err.println("Error loading images");
            this.message = "Error loading images";
        } else {
            this.message = null;
            System.out.println(this.tracker.checkID(0));
            System.out.println("Loaded backgrounds");
            System.out.println("mainPanel = " + this.mainPanel);
            if (this.mainPanel != null) {
                return;
            }
            this.mainPanel = new Panel();
            this.mainPanel.setLayout(new BorderLayout());
            if (this.expNumber == null) {
                this.changeExp = new Button(TO_EXP2);
                Panel panel = new Panel();
                panel.add(this.changeExp);
                this.mainPanel.add("North", panel);
                this.expNumber = "1";
            }
            this.circuit = new Circuit(this.imgCircuit);
            this.scope = new Oscilloscope(this.circuit, this.imgScope);
            this.mainPanel.add("Center", this.scope);
            this.mainPanel.add("South", this.circuit);
            this.mainPanel.resize(this.mainPanel.preferredSize());
            this.add(this.mainPanel);
            this.mainPanel.validate();
            this.resize(this.preferredSize());
            this.validate();
        }
        if (this.expNumber.equals("1")) {
            this.initExp1();
            return;
        }
        if (this.expNumber.equals("2")) {
            this.initExp2();
            return;
        }
        if (this.expNumber.equals("3")) {
            this.initExp3();
            return;
        }
        System.err.println("Unknown experiment number " + this.expNumber);
    }

    public void destroy() {
        System.out.println("Destroy entered");
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.changeExp) {
            String string = this.changeExp.getLabel();
            if (string == TO_EXP1) {
                this.changeExp.setLabel(TO_EXP2);
                this.initExp1();
            } else if (string == TO_EXP2) {
                this.changeExp.setLabel(TO_EXP3);
                this.initExp2();
            } else if (string == TO_EXP3) {
                this.changeExp.setLabel(TO_EXP1);
                this.initExp3();
            }
        } else {
            if (event.target == this.circuit) {
                this.scope.repaint();
                return true;
            }
            System.err.println("Simulation Action: Unknown Event" + event);
        }
        return super.action(event, object);
    }

    public void paint(Graphics graphics) {
        if (this.message == null) {
            return;
        }
        graphics.drawString(this.message, 20, 20);
    }

    void initExp1() {
        System.out.println("Initializing exp1");
        this.circuit.setExperiment(1);
        this.scope.setMode(0);
        this.scope.repaint();
    }

    void initExp2() {
        System.out.println("Initializing exp2");
        this.circuit.setExperiment(2);
        this.scope.setMode(0);
        this.scope.repaint();
    }

    void initExp3() {
        System.out.println("Initializing exp3");
        this.circuit.setExperiment(3);
        this.scope.setMode(1);
        this.scope.repaint();
    }
}

