/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public class OscilloscopeScreen
extends Canvas {
    Probeable p;
    private int xOrigin;
    private int yOrigin;
    private int xSize;
    private int ySize;
    private int xShift;
    private int yShiftA;
    private int yShiftB;
    private double xScale;
    private double yScaleA;
    private double yScaleB;
    String xScaleTitle = "s/div";
    String yScaleATitle = "V/div";
    String yScaleBTitle = "V/div";
    String posInfoA;
    String posInfoB;
    final int N_DIV = 10;
    Image offScrImg;
    Color colorX;
    Color colorA;
    Color colorB;

    OscilloscopeScreen(Probeable probeable, Dimension dimension) {
        this(probeable, 0, 0, dimension.width, dimension.height);
    }

    OscilloscopeScreen(Probeable probeable, int n, int n2, int n3, int n4) {
        this.resize(n3, n4);
        this.p = probeable;
        this.xOrigin = n;
        this.yOrigin = n2;
        this.xSize = n3;
        this.ySize = n4;
        this.xScale = 1.0 / (double)this.xSize;
        this.yScaleA = this.ySize;
        this.yScaleB = this.ySize;
        this.posInfoA = "";
        this.posInfoB = "";
        this.repaint();
    }

    public void setCenter(Point point) {
        this.reshape(point.x - this.xSize / 2, point.y - this.ySize / 2, this.xSize, this.ySize);
    }

    void setXScale(double d, String string) {
        this.xScale = d / (double)this.xSize;
        this.xScaleTitle = string;
        this.repaint();
    }

    void setYScaleA(double d, String string) {
        this.yScaleA = (double)this.ySize / d;
        this.yScaleATitle = string;
        this.repaint();
    }

    void setYScaleB(double d, String string) {
        this.yScaleB = (double)this.ySize / d;
        this.yScaleBTitle = string;
        this.repaint();
    }

    void setYShiftA(double d) {
        this.yShiftA = (int)(d * (double)this.ySize);
        this.repaint();
    }

    void setYShiftB(double d) {
        this.yShiftB = (int)(d * (double)this.ySize);
        this.repaint();
    }

    void setXShift(double d) {
        this.xShift = (int)(d * (double)this.xSize);
        this.repaint();
    }

    void setChXColor(Color color) {
        this.colorX = color;
    }

    void setChAColor(Color color) {
        this.colorA = color;
    }

    void setChBColor(Color color) {
        this.colorB = color;
    }

    public void update(Graphics graphics) {
        if (this.offScrImg == null) {
            this.offScrImg = this.createImage(this.xSize, this.ySize);
        }
        Color color = graphics.getColor();
        if (this.posInfoA.length() == 0 && this.posInfoB.length() == 0) {
            Graphics graphics2 = this.offScrImg.getGraphics();
            graphics2.setColor(color);
            graphics2.setFont(graphics.getFont());
            this.paint(graphics2);
            graphics.drawImage(this.offScrImg, this.xOrigin, this.yOrigin, this);
            graphics2.dispose();
            return;
        }
        this.drawInfo(graphics);
    }

    public void paint(Graphics graphics) {
        double[] dArray = new double[2];
        graphics.setColor(Color.black);
        graphics.fillRect(this.xOrigin, this.yOrigin, this.xSize, this.ySize);
        this.drawScreen(graphics);
        int n = this.xOrigin + 1;
        dArray = this.p.probeA(0.0, this.xScale);
        int n2 = (int)((double)(this.yOrigin + this.ySize - this.yShiftA) - dArray[0] * this.yScaleA);
        int n3 = (int)((double)(this.yOrigin + this.ySize - this.yShiftA) - dArray[1] * this.yScaleA);
        dArray = this.p.probeB(0.0, this.xScale);
        int n4 = (int)((double)(this.yOrigin + this.ySize - this.yShiftB) - dArray[0] * this.yScaleB);
        int n5 = (int)((double)(this.yOrigin + this.ySize - this.yShiftB) - dArray[1] * this.yScaleB);
        int n6 = 1;
        while (n6 < this.xSize) {
            int n7;
            double d = (double)(n6 - this.xShift) * this.xScale;
            int n8 = this.xOrigin + n6;
            graphics.setColor(this.colorA);
            dArray = this.p.probeA(d, this.xScale);
            int n9 = (int)((double)(this.yOrigin + this.ySize - this.yShiftA) - dArray[0] * this.yScaleA);
            int n10 = (int)((double)(this.yOrigin + this.ySize - this.yShiftA) - dArray[1] * this.yScaleA);
            if (n9 > n10) {
                n7 = n9;
                n9 = n10;
                n10 = n7;
            }
            if (n9 > n3) {
                graphics.drawLine(n, n2, n8, n10);
            } else if (n10 < n2) {
                graphics.drawLine(n, n3, n8, n9);
            } else {
                graphics.drawLine(n8, n9, n8, n10);
            }
            n2 = n9;
            n3 = n10;
            graphics.setColor(this.colorB);
            dArray = this.p.probeB(d, this.xScale);
            n9 = (int)((double)(this.yOrigin + this.ySize - this.yShiftB) - dArray[0] * this.yScaleB);
            n10 = (int)((double)(this.yOrigin + this.ySize - this.yShiftB) - dArray[1] * this.yScaleB);
            if (n9 > n10) {
                n7 = n9;
                n9 = n10;
                n10 = n7;
            }
            if (n9 > n5) {
                graphics.drawLine(n, n4, n8, n10);
            } else if (n10 < n4) {
                graphics.drawLine(n, n5, n8, n9);
            } else {
                graphics.drawLine(n8, n9, n8, n10);
            }
            n4 = n9;
            n5 = n10;
            n = n8;
            ++n6;
        }
        this.drawInfo(graphics);
        graphics.setColor(this.getForeground());
    }

    private void drawInfo(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n = this.yOrigin + this.ySize - fontMetrics.getHeight() / 2;
        graphics.setColor(this.colorX);
        String string = String.valueOf(Notation.engineering((double)this.xSize * this.xScale / 10.0)) + this.xScaleTitle + "/div";
        int n2 = this.xOrigin + this.xSize - fontMetrics.stringWidth(String.valueOf(string) + "AA");
        graphics.drawString(string, n2, n);
        graphics.setColor(this.colorB);
        n2 = this.xOrigin + fontMetrics.stringWidth("AA");
        string = String.valueOf(Notation.engineering((double)this.ySize / (this.yScaleB * 10.0))) + this.yScaleBTitle + "/div";
        graphics.drawString(string, n2, n);
        graphics.setColor(this.colorA);
        string = String.valueOf(Notation.engineering((double)this.ySize / (this.yScaleA * 10.0))) + this.yScaleATitle + "/div";
        graphics.drawString(string, n2, n -= fontMetrics.getHeight());
        n2 = this.xOrigin + fontMetrics.stringWidth("AA");
        n = fontMetrics.getHeight();
        graphics.setColor(this.colorA);
        graphics.drawString(this.posInfoA, n2, n);
        graphics.setColor(this.colorB);
        graphics.drawString(this.posInfoB, n2, n += fontMetrics.getHeight());
        graphics.setColor(this.getForeground());
    }

    private void drawScreen(Graphics graphics) {
        graphics.setColor(Color.gray);
        int n = 1;
        while (n < 10) {
            int n2 = this.xOrigin + n * this.xSize / 10;
            int n3 = this.yOrigin + n * this.ySize / 10;
            graphics.drawLine(n2, this.yOrigin, n2, this.yOrigin + this.ySize);
            graphics.drawLine(this.xOrigin, n3, this.xOrigin + this.xSize, n3);
            ++n;
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        double d = (double)(-n2 + this.yOrigin + this.ySize - this.yShiftA) / this.yScaleA;
        double d2 = (double)(-n2 + this.yOrigin + this.ySize - this.yShiftB) / this.yScaleB;
        double d3 = (double)n * this.xScale;
        this.posInfoA = "(" + Notation.engineering(d3) + this.xScaleTitle + "," + Notation.engineering(d) + this.yScaleBTitle + ")";
        this.posInfoB = "(" + Notation.engineering(d3) + this.xScaleTitle + "," + Notation.engineering(d2) + this.yScaleBTitle + ")";
        this.repaint();
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.posInfoA = "";
        this.posInfoB = "";
        this.repaint();
        return true;
    }
}

