/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;

public class Oscilloscope
extends Panel {
    final double[] sweepTime = new double[]{5000.0, 2000.0, 1000.0, 500.0, 200.0, 100.0, 50.0, 20.0, 10.0, 5.0, 2.0, 1.0, 0.5, 0.2, 0.1, 0.05, 0.02, 0.01, 0.005, 0.002, 0.001, 5.0E-4, 2.0E-4, 1.0E-4, 5.0E-5, 2.0E-5, 1.0E-5, 5.0E-6, 2.0E-6, 1.0E-6};
    final int MIN_TIME = 0;
    final int MAX_TIME = 29;
    final int INIT_TIME = 8;
    final double[] voltage = new double[]{5000.0, 2000.0, 1000.0, 500.0, 200.0, 100.0, 50.0, 20.0, 10.0, 5.0, 2.0, 1.0, 0.5, 0.2, 0.1, 0.05, 0.02, 0.01, 0.005, 0.002, 0.001, 5.0E-4, 2.0E-4, 1.0E-4, 5.0E-5, 2.0E-5, 1.0E-5, 5.0E-6, 2.0E-6, 1.0E-6};
    final int MIN_VOLTAGE = 0;
    final int MAX_VOLTAGE = 29;
    final int INIT_VOLTAGE = 23;
    final int MIN_SHIFT = 0;
    final int MAX_SHIFT = 20;
    final int INIT_SHIFT_A = 14;
    final int INIT_SHIFT_B = 6;
    final int MIN_SHIFT_X = -20;
    final int MAX_SHIFT_X = 0;
    final int INIT_SHIFT_X = 0;
    public static final int X_TIME = 0;
    public static final int X_VOLT = 1;
    int xMode = 0;
    Image offScrImage;
    Image background;
    OscilloscopeScreen screen;
    Point screenPos = new Point(116, 97);
    Dimension screenSize = new Dimension(190, 155);
    Knob xRange;
    Point xRangePos = new Point(355, 111);
    Knob xShift;
    Point xShiftPos = new Point(355, 159);
    Knob yRangeA;
    Point yRangeAPos = new Point(255, 111);
    Knob yRangeB;
    Point yRangeBPos = new Point(299, 111);
    Knob yShiftA;
    Point yShiftAPos = new Point(255, 159);
    Knob yShiftB;
    Point yShiftBPos = new Point(299, 159);
    Dimension knobSize = new Dimension(38, 44);
    public static final Color COLOR_A = new Color(240, 240, 0);
    public static final Color COLOR_B = new Color(50, 255, 50);
    public static final Color COLOR_X = new Color(100, 100, 255);
    public static final Color COLOR_T = new Color(255, 150, 255);

    Oscilloscope(Probeable probeable, Image image) {
        this.setLayout(null);
        this.background = image;
        this.screen = new OscilloscopeScreen(probeable, this.screenSize);
        this.screen.setYShiftA(this.indToShift(14));
        this.screen.setYShiftB(this.indToShift(6));
        this.screen.setYScaleA(this.indToVoltage(23), "V");
        this.screen.setYScaleB(this.indToVoltage(23), "V");
        this.screen.setXScale(this.indToTime(8), "s");
        this.screen.setChXColor(COLOR_X.brighter());
        this.screen.setChAColor(COLOR_A.brighter());
        this.screen.setChBColor(COLOR_B.brighter());
        this.add(this.screen);
        this.screen.setCenter(this.screenPos);
        this.yRangeA = new Knob(23, 0, 29, this.knobSize);
        this.yRangeA.setBackgroundImage(this.background, this.yRangeAPos, this.knobSize);
        this.yRangeA.setKnobColor(COLOR_A);
        this.add(this.yRangeA);
        this.yRangeA.setCenter(this.yRangeAPos);
        this.yRangeA.setTitle("V/div");
        this.yRangeB = new Knob(23, 0, 29, this.knobSize);
        this.yRangeB.setBackgroundImage(this.background, this.yRangeBPos, this.knobSize);
        this.yRangeB.setKnobColor(COLOR_B);
        this.add(this.yRangeB);
        this.yRangeB.setCenter(this.yRangeBPos);
        this.yRangeB.setTitle("V/div");
        this.xRange = new Knob(8, 0, 29, this.knobSize);
        this.xRange.setBackgroundImage(this.background, this.xRangePos, this.knobSize);
        this.xRange.setKnobColor(COLOR_X);
        this.add(this.xRange);
        this.xRange.setCenter(this.xRangePos);
        if (this.xMode == 0) {
            this.xRange.setTitle("s/div");
        } else {
            this.xRange.setTitle("V/div");
        }
        this.yShiftA = new Knob(14, 0, 20, this.knobSize);
        this.yShiftA.setBackgroundImage(this.background, this.yShiftAPos, this.knobSize);
        this.yShiftA.setKnobColor(COLOR_A);
        this.add(this.yShiftA);
        this.yShiftA.setCenter(this.yShiftAPos);
        this.yShiftA.setTitle("Pos.");
        this.yShiftB = new Knob(6, 0, 20, this.knobSize);
        this.yShiftB.setBackgroundImage(this.background, this.yShiftBPos, this.knobSize);
        this.yShiftB.setKnobColor(COLOR_B);
        this.add(this.yShiftB);
        this.yShiftB.setCenter(this.yShiftBPos);
        this.yShiftB.setTitle("Pos.");
        this.xShift = new Knob(0, -20, 0, this.knobSize);
        this.xShift.setBackgroundImage(this.background, this.xShiftPos, this.knobSize);
        this.xShift.setKnobColor(COLOR_X);
        this.add(this.xShift);
        this.xShift.setCenter(this.xShiftPos);
        this.xShift.setTitle("Pos.");
    }

    public Dimension preferredSize() {
        return new Dimension(this.background.getWidth(this), this.background.getHeight(this));
    }

    public Dimension minimumSize() {
        return new Dimension(this.background.getWidth(this), this.background.getHeight(this));
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (!this.prepareImage(this.background, this)) {
            return;
        }
        graphics.drawImage(this.background, 0, 0, this);
        if (!this.yRangeA.OK()) {
            this.yRangeA.setBackgroundImage(this.background, this.yRangeAPos, this.knobSize);
        }
        if (!this.yRangeB.OK()) {
            this.yRangeB.setBackgroundImage(this.background, this.yRangeBPos, this.knobSize);
        }
        if (!this.xRange.OK()) {
            this.xRange.setBackgroundImage(this.background, this.xRangePos, this.knobSize);
        }
        if (!this.yShiftA.OK()) {
            this.yShiftA.setBackgroundImage(this.background, this.yShiftAPos, this.knobSize);
        }
        if (!this.yShiftB.OK()) {
            this.yShiftB.setBackgroundImage(this.background, this.yShiftBPos, this.knobSize);
        }
        this.drawLabels(graphics);
        this.screen.repaint();
    }

    private void drawLabels(Graphics graphics) {
        graphics.setFont(new Font("Helvetica", 0, 11));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = "Ch. A";
        graphics.drawString(string, this.yRangeAPos.x - fontMetrics.stringWidth(string) / 2, this.yRangeAPos.y - this.knobSize.height / 2);
        string = "Ch. B";
        graphics.drawString(string, this.yRangeBPos.x - fontMetrics.stringWidth(string) / 2, this.yRangeBPos.y - this.knobSize.height / 2);
        string = "Horiz.";
        graphics.drawString(string, this.xRangePos.x - fontMetrics.stringWidth(string) / 2, this.xRangePos.y - this.knobSize.height / 2);
    }

    public void setMode(int n) {
        if (n != this.xMode) {
            if (n == 0) {
                this.xRange.setValues(8, 0, 29);
                this.screen.setXScale(this.indToTime(8), "s");
                this.xMode = 0;
                this.xRange.setTitle("s/div");
                return;
            }
            if (n == 1) {
                this.xRange.setValues(23, 0, 29);
                this.screen.setXScale(this.indToVoltage(23), "V");
                this.xMode = 1;
                this.xRange.setTitle("V/div");
            }
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 1001: {
                if (event.target == this.xRange) {
                    int n = this.xRange.getValue();
                    if (this.xMode == 0) {
                        this.screen.setXScale(this.indToTime(n), "s");
                    } else if (this.xMode == 1) {
                        this.screen.setXScale(this.indToVoltage(n), "V");
                    }
                    return true;
                }
                if (event.target == this.yRangeA) {
                    int n = this.yRangeA.getValue();
                    this.screen.setYScaleA(this.indToVoltage(n), "V");
                    return true;
                }
                if (event.target == this.yRangeB) {
                    int n = this.yRangeB.getValue();
                    this.screen.setYScaleB(this.indToVoltage(n), "V");
                    return true;
                }
                if (event.target == this.yShiftA) {
                    int n = this.yShiftA.getValue();
                    this.screen.setYShiftA(this.indToShift(n));
                    return true;
                }
                if (event.target == this.yShiftB) {
                    int n = this.yShiftB.getValue();
                    this.screen.setYShiftB(this.indToShift(n));
                    return true;
                }
                if (event.target == this.xShift) {
                    int n = this.xShift.getValue();
                    this.screen.setXShift(this.indToShiftX(n));
                    return true;
                }
                System.err.println("Scope Event: Unknown Event" + event);
                break;
            }
        }
        return super.handleEvent(event);
    }

    private double indToShift(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 20) {
            n = 20;
        }
        return (double)n / 20.0;
    }

    private double indToShiftX(int n) {
        if (n < -20) {
            n = -20;
        }
        if (n > 0) {
            n = 0;
        }
        return (double)n / 20.0;
    }

    private double indToTime(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 29) {
            n = 29;
        }
        return this.sweepTime[n];
    }

    private double indToVoltage(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 29) {
            n = 29;
        }
        return this.voltage[n];
    }
}

