/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class Knob
extends Canvas {
    int disabled;
    int stepMin;
    int stepMax = 10;
    int stepKnob;
    int stepOld;
    static final double ANGLE_MIN = -3.9269908169872414;
    static final double ANGLE_MAX = 0.7853981633974483;
    double angleStep = 4.71238898038469 / (double)(this.stepMax - this.stepMin);
    Image background;
    Color color;
    static final Dimension DEFAULT_SIZE = new Dimension(60, 65);
    int width;
    int height;
    int sizeKnob;
    int sizeScale;
    int x0;
    int y0;
    String title;
    Image offScrImg;
    int xD = -100;
    int yD = -100;

    Knob(int n, int n2, int n3) {
        this(n, n2, n3, null, DEFAULT_SIZE);
    }

    Knob(int n, int n2, int n3, String string) {
        this(n, n2, n3, string, DEFAULT_SIZE);
    }

    Knob(int n, int n2, int n3, Dimension dimension) {
        this(n, n2, n3, null, dimension);
    }

    Knob(int n, int n2, int n3, String string, Dimension dimension) {
        this.stepKnob = n;
        this.stepMin = n2;
        this.stepMax = n3;
        this.title = string;
        this.width = dimension.width;
        this.height = dimension.height;
        if (this.height < this.width) {
            this.height = this.width;
        }
        this.sizeScale = this.width - 2;
        this.sizeScale = 2 * (this.sizeScale / 2);
        this.sizeKnob = (int)Math.round(0.7 * (double)this.sizeScale);
        this.sizeKnob = 4 * (this.sizeKnob / 4);
        this.x0 = this.width / 2;
        this.y0 = this.width / 2;
        this.angleStep = 4.71238898038469 / (double)(n3 - n2);
        this.stepOld = n;
    }

    public void enable() {
        this.disabled = 0;
        this.repaint();
    }

    public void disable() {
        this.disabled = 1;
        this.repaint();
    }

    public void setBackgroundImage(Image image) {
        this.background = image;
    }

    public void setBackgroundImage(Image image, Point point, Dimension dimension) {
        int n = point.x - dimension.width / 2;
        int n2 = point.y - dimension.width / 2;
        int n3 = dimension.width;
        int n4 = dimension.height;
        if (image == null) {
            return;
        }
        int n5 = image.getWidth(this);
        int n6 = image.getHeight(this);
        if (n >= n5) {
            return;
        }
        if (n2 >= n6) {
            return;
        }
        if (n + n3 > n5) {
            n3 = n5 - n;
        }
        if (n2 + n4 > n6) {
            n4 = n6 - n2;
        }
        int[] nArray = new int[n3 * n4];
        PixelGrabber pixelGrabber = new PixelGrabber(image, n, n2, n3, n4, nArray, 0, n3);
        try {
            int n7 = 0;
            while (n7 < 3) {
                if (pixelGrabber.grabPixels(1000L)) break;
                ++n7;
            }
            if (n7 == 3) {
                System.err.println("Could not get sub-image A");
                this.background = null;
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Could not get sub-image B");
            this.background = null;
            return;
        }
        if ((pixelGrabber.status() & 0x80) != 0) {
            System.err.println("Could not get sub-image C");
            this.background = null;
            return;
        }
        this.background = this.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
    }

    public void setKnobColor(Color color) {
        this.color = color;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.background != null) {
            graphics.drawImage(this.background, 0, 0, this);
        }
        if (this.disabled == 1) {
            return;
        }
        int n = this.x0 - this.sizeKnob / 2;
        int n2 = this.y0 - this.sizeKnob / 2;
        graphics.setColor(this.color.darker());
        graphics.fillOval(n, n2, this.sizeKnob, this.sizeKnob);
        n = this.x0 - this.sizeKnob / 4;
        n2 = this.y0 - this.sizeKnob / 4;
        graphics.setColor(this.color);
        graphics.fillOval(n, n2, this.sizeKnob / 2, this.sizeKnob / 2);
        n = this.x0 - this.sizeKnob / 2;
        n2 = this.y0 - this.sizeKnob / 2;
        graphics.setColor(this.getForeground());
        graphics.drawOval(n, n2, this.sizeKnob, this.sizeKnob);
        double d = -3.9269908169872414 + (double)(this.stepKnob - this.stepMin) * this.angleStep;
        double d2 = -Math.sin(d);
        double d3 = Math.cos(d);
        n = this.x0 + (int)(d3 * (double)this.sizeKnob / 4.0);
        n2 = this.y0 - (int)(d2 * (double)this.sizeKnob / 4.0);
        int n3 = this.x0 + (int)(d3 * (double)this.sizeKnob / 2.0);
        int n4 = this.y0 - (int)(d2 * (double)this.sizeKnob / 2.0);
        graphics.setColor(Color.white);
        graphics.drawLine(n, n2, n3, n4);
        graphics.setColor(this.getForeground());
        n = this.x0 - this.sizeScale / 2;
        n2 = this.y0 - this.sizeScale / 2;
        n3 = 224;
        n4 = -270;
        graphics.drawArc(n, n2, this.sizeScale, this.sizeScale, n3, n4);
        d = -3.9269908169872414;
        d2 = -Math.sin(d);
        d3 = Math.cos(d);
        n = this.x0 + (int)(d3 * (double)this.sizeKnob / 2.0);
        n2 = this.y0 - (int)(d2 * (double)this.sizeKnob / 2.0);
        n3 = this.x0 + (int)(d3 * (double)this.sizeScale / 2.0);
        n4 = this.y0 - (int)(d2 * (double)this.sizeScale / 2.0);
        graphics.drawLine(n, n2, n3, n4);
        d = 0.7853981633974483;
        d2 = -Math.sin(d);
        d3 = Math.cos(d);
        n = this.x0 + (int)(d3 * (double)this.sizeKnob / 2.0);
        n2 = this.y0 - (int)(d2 * (double)this.sizeKnob / 2.0);
        n3 = this.x0 + (int)(d3 * (double)this.sizeScale / 2.0);
        n4 = this.y0 - (int)(d2 * (double)this.sizeScale / 2.0);
        graphics.drawLine(n, n2, n3, n4);
        if (this.title != null && !this.title.equals("")) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n = this.x0 - fontMetrics.stringWidth(this.title) / 2;
            n2 = this.height - fontMetrics.getDescent();
            graphics.drawString(this.title, n, n2);
        }
    }

    public Dimension preferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension minimumSize() {
        return new Dimension(this.width, this.height);
    }

    public void setCenter(Point point) {
        this.move(point.x - this.x0, point.y - this.y0);
        this.resize(this.width, this.height);
    }

    public int getValue() {
        return this.stepKnob;
    }

    public void setValue(int n) {
        this.stepKnob = n;
        this.repaint();
    }

    public void setTitle(String string) {
        this.title = string;
        this.repaint();
    }

    public void setValues(int n, int n2, int n3) {
        this.setValues(n, n2, n3, null);
    }

    public void setValues(int n, int n2, int n3, String string) {
        this.stepKnob = n;
        this.stepMin = n2;
        this.stepMax = n3;
        this.title = string;
        this.angleStep = 4.71238898038469 / (double)(n3 - n2);
        this.stepOld = n;
        this.repaint();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.xD = n;
        this.yD = n2;
        this.stepKnob(n, n2);
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (Math.abs(n - this.xD) > 2 || Math.abs(n2 - this.yD) > 2) {
            this.xD = -100;
            this.yD = -100;
            this.adjustKnob(n, n2);
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.stepKnob != this.stepOld) {
            Event event2 = new Event(this, 1001, this);
            this.getParent().postEvent(event2);
            this.stepOld = this.stepKnob;
        }
        return true;
    }

    private void stepKnob(int n, int n2) {
        double d = n - this.x0;
        double d2 = this.y0 - n2;
        if (2.0 * Math.sqrt(d * d + d2 * d2) < (double)this.width) {
            int n3;
            double d3 = -Math.atan2(d2, d);
            if (d3 > 1.5707963267948966) {
                d3 -= Math.PI * 2;
            }
            if ((n3 = this.stepMin + (int)(((d3 -= -3.9269908169872414) + this.angleStep / 2.0) / this.angleStep)) >= this.stepMin && n3 <= this.stepMax && n3 != this.stepKnob) {
                double d4 = (double)(this.stepKnob - this.stepMin) * this.angleStep;
                this.stepKnob = d3 < d4 ? --this.stepKnob : ++this.stepKnob;
                this.repaint();
            }
        }
    }

    private void adjustKnob(int n, int n2) {
        double d = n - this.x0;
        double d2 = this.y0 - n2;
        if (2.0 * Math.sqrt(d * d + d2 * d2) < (double)this.width) {
            int n3;
            double d3 = -Math.atan2(d2, d);
            if (d3 > 1.5707963267948966) {
                d3 -= Math.PI * 2;
            }
            if ((n3 = this.stepMin + (int)(((d3 -= -3.9269908169872414) + this.angleStep / 2.0) / this.angleStep)) >= this.stepMin && n3 <= this.stepMax && n3 != this.stepKnob) {
                this.stepKnob = n3;
                this.repaint();
            }
        }
    }

    public boolean OK() {
        return this.background != null;
    }
}

