/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URL;

class ExternData {
    int maxPoints = 800;
    double[] dataPoints;
    int dataPointsNo;
    boolean periodic = true;

    ExternData(URL uRL) {
        if (uRL == null) {
            return;
        }
        try {
            System.out.println("ExternData: loading " + uRL);
            DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
            this.readData(dataInputStream);
            return;
        }
        catch (IOException iOException) {
            System.out.println("ExternData: IOException(1): " + iOException);
            uRL = null;
            return;
        }
    }

    void readData(DataInputStream dataInputStream) {
        double d = 0.0;
        this.dataPointsNo = 0;
        if (dataInputStream != null) {
            try {
                String string;
                if (this.dataPoints == null) {
                    this.dataPoints = new double[this.maxPoints];
                }
                while ((string = dataInputStream.readLine()) != null) {
                    double d2;
                    if (this.dataPointsNo >= this.maxPoints) {
                        this.expandDataArray(this.dataPoints);
                    }
                    if (Math.abs(d2 = Double.valueOf(string).doubleValue()) > d) {
                        d = Math.abs(d2);
                    }
                    this.dataPoints[this.dataPointsNo] = d2;
                    ++this.dataPointsNo;
                }
                return;
            }
            catch (EOFException eOFException) {
                return;
            }
            catch (IOException iOException) {
                return;
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
    }

    void expandDataArray(double[] dArray) {
        this.maxPoints *= 2;
        this.dataPoints = new double[this.maxPoints];
        int n = 0;
        while (n < this.dataPointsNo) {
            this.dataPoints[n] = dArray[n];
            ++n;
        }
        System.out.println("ExternData:expandDataArray: new size is " + this.maxPoints);
    }

    int getPointsNo() {
        return this.dataPointsNo;
    }

    double getDataVal(int n) {
        if (n < 0 || n >= this.dataPointsNo) {
            return 0.0;
        }
        return this.dataPoints[n];
    }

    double[] getDataValRange(int n, int n2) {
        double[] dArray = new double[2];
        if (!(this.periodic || n >= 0 && n < this.dataPointsNo && n2 >= 0 && n2 < this.dataPointsNo)) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
        } else {
            int n3 = n2 % this.dataPointsNo;
            dArray[0] = this.dataPoints[n3];
            dArray[1] = this.dataPoints[n3];
            int n4 = n;
            while (n4 < n2) {
                n3 = n4 % this.dataPointsNo;
                if (dArray[0] > this.dataPoints[n3]) {
                    dArray[0] = this.dataPoints[n3];
                }
                if (dArray[1] < this.dataPoints[n3]) {
                    dArray[1] = this.dataPoints[n3];
                }
                ++n4;
            }
        }
        return dArray;
    }
}

