/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Choice;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.net.MalformedURLException;
import java.net.URL;

class Dataset
extends Panel
implements Probeable {
    URL codeBase;
    int noDataset;
    int noDatasetMax;
    ExternData[] data;
    double[] scale;
    Choice channelA;
    Choice channelB;
    int indexA;
    int indexB;
    double scaleA;
    double scaleB;

    Dataset(Applet applet, int n) {
        this.codeBase = applet.getCodeBase();
        this.noDatasetMax = n;
        this.noDataset = 0;
        this.data = new ExternData[n];
        this.scale = new double[n];
        this.channelA = new Choice();
        this.channelB = new Choice();
        this.setLayout(new GridLayout(2, 2));
        this.add(new Label("Select data source for channel A"));
        this.add(new Label("Select data source for channel B"));
        this.add(this.channelA);
        this.add(this.channelB);
    }

    void addDataset(String string, String string2, double d) {
        if (this.noDataset >= this.noDatasetMax) {
            return;
        }
        try {
            this.data[this.noDataset] = new ExternData(new URL(this.codeBase, string));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Dataset.addDataset: bad URL: " + string);
            return;
        }
        if (string2 != null) {
            this.channelA.addItem(string2);
            this.channelB.addItem(string2);
        } else {
            this.channelA.addItem(string);
            this.channelB.addItem(string);
        }
        this.scale[this.noDataset] = d;
        this.indexA = 0;
        this.channelA.select(this.indexA);
        this.indexB = this.noDataset > 0 ? 1 : 0;
        this.channelB.select(this.indexB);
        ++this.noDataset;
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.channelA) {
            this.indexA = this.channelA.getSelectedIndex();
            Event event2 = new Event(this, 1001, this);
            this.getParent().postEvent(event2);
            return true;
        }
        if (event.target == this.channelB) {
            this.indexB = this.channelB.getSelectedIndex();
            Event event3 = new Event(this, 1001, this);
            this.getParent().postEvent(event3);
            return true;
        }
        System.err.println("Dataset:action: Unknown Event" + event);
        return false;
    }

    public double[] probeA(double d, double d2) {
        double[] dArray = new double[2];
        dArray = this.getAmp(this.indexA, d, d2);
        return dArray;
    }

    public double[] probeB(double d, double d2) {
        double[] dArray = new double[2];
        dArray = this.getAmp(this.indexB, d, d2);
        return dArray;
    }

    double[] getAmp(int n, double d, double d2) {
        double[] dArray = new double[2];
        int n2 = (int)Math.round(d * this.scale[n]);
        int n3 = (int)Math.round((d + d2) * this.scale[n]);
        dArray = this.data[n].getDataValRange(n2, n3);
        return dArray;
    }
}

