/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;

class Circuit
extends Panel
implements Probeable {
    final double s2 = Math.sqrt(2.0);
    int experiment;
    final double[] valCa = new double[]{1.0E-10, 1.1E-10, 1.2E-10, 1.3E-10, 1.5E-10, 1.6E-10, 1.8E-10, 2.0E-10, 2.2E-10, 2.4E-10, 2.7E-10, 3.0E-10, 3.3E-10, 3.6E-10, 3.9E-10, 4.2E-10, 4.7E-10, 5.1E-10, 5.6E-10, 6.2E-10, 6.8E-10, 7.5E-10, 8.2E-10, 9.1E-10, 1.0E-9};
    final int MIN_CA = 0;
    final int MAX_CA = 24;
    final int INIT_CA = 12;
    final double[] valCc = new double[]{3.3E-9, 3.9E-9, 4.7E-9, 5.6E-9, 6.8E-9, 8.2E-9, 1.0E-8, 1.2E-8, 1.5E-8, 1.8E-8, 2.2E-8, 2.7E-8, 3.3E-8, 4.7E-8, 5.6E-8};
    final int MIN_CC = 0;
    final int MAX_CC = 14;
    final int INIT_CC = 6;
    final int MIN_F = 700;
    final int MAX_F = 1100;
    final int INIT_F = 900;
    final double DELTA_F = 100.0;
    final int DF_DV = 100;
    Image background;
    Point labelOscPos = new Point(35, 85);
    Point labelCaPos = new Point(328, 27);
    Point labelCcPos = new Point(328, 65);
    Point labelFPos = new Point(328, 101);
    Knob knobCa;
    Point knobCaPos = new Point(249, 24);
    Knob knobCc;
    Point knobCcPos = new Point(249, 62);
    Knob knobF;
    Point knobFPos = new Point(249, 98);
    Dimension knobSize = new Dimension(36, 36);
    public static final Color COLOR_T = new Color(255, 0, 0);
    private double ca;
    private double cb;
    private double la;
    private double lb;
    private double ra;
    private double rb;
    private double cc;
    private double f;
    private double f0;
    private double fp;
    private double fm;
    private double aa1;
    private double ba1;
    private double ab1;
    private double bb1;
    private double a2R;
    private double b2R;
    private double a2I;
    private double b2I;

    Circuit(Image image) {
        this.setLayout(null);
        this.background = image;
        this.knobCa = new Knob(12, 0, 24, this.knobSize);
        this.knobCa.setBackgroundImage(this.background, this.knobCaPos, this.knobSize);
        this.knobCa.setKnobColor(COLOR_T);
        this.add(this.knobCa);
        this.knobCa.setCenter(this.knobCaPos);
        this.knobCc = new Knob(6, 0, 14, this.knobSize);
        this.knobCc.setBackgroundImage(this.background, this.knobCcPos, this.knobSize);
        this.knobCc.setKnobColor(COLOR_T);
        this.add(this.knobCc);
        this.knobCc.setCenter(this.knobCcPos);
        this.knobF = new Knob(900, 700, 1100, this.knobSize);
        this.knobF.setBackgroundImage(this.background, this.knobFPos, this.knobSize);
        this.knobF.setKnobColor(COLOR_T);
        this.add(this.knobF);
        this.knobF.setCenter(this.knobFPos);
        this.setExperiment(1);
    }

    public Dimension preferredSize() {
        return new Dimension(this.background.getWidth(this), this.background.getHeight(this));
    }

    public Dimension minimumSize() {
        return new Dimension(this.background.getWidth(this), this.background.getHeight(this));
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (!this.prepareImage(this.background, this)) {
            return;
        }
        graphics.drawImage(this.background, 0, 0, this);
        if (!this.knobCa.OK()) {
            this.knobCa.setBackgroundImage(this.background, this.knobCaPos, this.knobSize);
        }
        if (!this.knobCc.OK()) {
            this.knobCc.setBackgroundImage(this.background, this.knobCcPos, this.knobSize);
        }
        if (!this.knobF.OK()) {
            this.knobF.setBackgroundImage(this.background, this.knobFPos, this.knobSize);
        }
        graphics.setFont(new Font("TimesRoman", 0, 11));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = String.valueOf(Notation.engineering(this.ca)) + "F";
        graphics.drawString(string, this.labelCaPos.x - fontMetrics.stringWidth(string) / 2, this.labelCaPos.y + fontMetrics.getHeight() / 2);
        string = String.valueOf(Notation.engineering(this.cc)) + "F";
        graphics.drawString(string, this.labelCcPos.x - fontMetrics.stringWidth(string) / 2, this.labelCcPos.y + fontMetrics.getHeight() / 2);
        if (this.experiment == 1) {
            string = "1V";
            graphics.setColor(Color.darkGray);
            graphics.drawString(string, this.labelOscPos.x, this.labelOscPos.y + fontMetrics.getAscent() / 2);
            this.drawWave(graphics, 1, this.labelOscPos.x + fontMetrics.stringWidth(String.valueOf(string) + " "), this.labelOscPos.y);
            graphics.setColor(this.getForeground());
            string = "10Hz";
            graphics.drawString(string, this.labelFPos.x - fontMetrics.stringWidth(string) / 2, this.labelFPos.y + fontMetrics.getHeight() / 2);
            return;
        }
        if (this.experiment == 2) {
            string = "1V";
            graphics.setColor(Color.darkGray);
            graphics.drawString(string, this.labelOscPos.x, this.labelOscPos.y + fontMetrics.getAscent() / 2);
            this.drawWave(graphics, 0, this.labelOscPos.x + fontMetrics.stringWidth(String.valueOf(string) + " "), this.labelOscPos.y);
            graphics.setColor(this.getForeground());
            string = String.valueOf(Notation.engineering(this.f)) + "Hz";
            graphics.drawString(string, this.labelFPos.x - fontMetrics.stringWidth(string) / 2, this.labelFPos.y + fontMetrics.getHeight() / 2);
            return;
        }
        if (this.experiment == 3) {
            string = "1V";
            graphics.setColor(Color.darkGray);
            graphics.drawString(string, this.labelOscPos.x, this.labelOscPos.y + fontMetrics.getAscent() / 2);
            this.drawWave(graphics, 0, this.labelOscPos.x + fontMetrics.stringWidth(String.valueOf(string) + " "), this.labelOscPos.y);
            graphics.setColor(this.getForeground());
            string = String.valueOf(Notation.engineering(this.f)) + "Hz + ";
            string = String.valueOf(string) + Notation.engineering(10000.0) + "Hz/V";
            graphics.drawString(string, this.labelFPos.x - fontMetrics.stringWidth(string) / 2, this.labelFPos.y + fontMetrics.getHeight() / 2);
        }
    }

    private void drawWave(Graphics graphics, int n, int n2, int n3) {
        if (n == 0) {
            int n4 = n2;
            int n5 = n3;
            int n6 = 0;
            while (n6 <= 10) {
                int n7 = n2 + n6;
                int n8 = (int)((double)n3 - 3.0 * Math.sin(Math.PI * (double)n6 / 5.0));
                graphics.drawLine(n4, n5, n7, n8);
                n4 = n7;
                n5 = n8;
                ++n6;
            }
            return;
        }
        graphics.drawLine(n2, n3, n2, n3 - 3);
        graphics.drawLine(n2, n3 - 3, n2 + 5, n3 - 3);
        graphics.drawLine(n2 + 5, n3 - 3, n2 + 5, n3 + 3);
        graphics.drawLine(n2 + 5, n3 + 3, n2 + 10, n3 + 3);
        graphics.drawLine(n2 + 10, n3 + 3, n2 + 10, n3);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.knobCa) {
            int n = this.knobCa.getValue();
            this.setCa(this.indToCa(n));
            Event event2 = new Event(this, 1001, this);
            this.getParent().postEvent(event2);
            return true;
        }
        if (event.target == this.knobCc) {
            int n = this.knobCc.getValue();
            this.setCc(this.indToCc(n));
            Event event3 = new Event(this, 1001, this);
            this.getParent().postEvent(event3);
            return true;
        }
        if (event.target == this.knobF) {
            if (this.experiment != 1) {
                int n = this.knobF.getValue();
                this.setF(this.indToF(n));
                Event event4 = new Event(this, 1001, this);
                this.getParent().postEvent(event4);
            }
            return true;
        }
        System.err.println("Circuit Action: Unknown Event" + event);
        return super.action(event, object);
    }

    private double indToCa(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 24) {
            n = 24;
        }
        return this.valCa[n];
    }

    private double indToCc(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 14) {
            n = 14;
        }
        return this.valCc[n];
    }

    private double indToF(int n) {
        if (n < 700) {
            n = 700;
        }
        if (n > 1100) {
            n = 1100;
        }
        return 100.0 * (double)n;
    }

    private void reInit() {
        if (this.experiment == 1) {
            this.reInitA();
            return;
        }
        this.reInitB(0.0);
    }

    private void reInitA() {
        double d = (this.ca + this.cc) / (this.la * this.ca * this.cc);
        double d2 = (this.cb + this.cc) / (this.lb * this.cb * this.cc);
        double d3 = 1.0 / (this.la * this.cc);
        double d4 = 1.0 / (this.lb * this.cc);
        double d5 = this.ra / this.la;
        double d6 = this.rb / this.lb;
        double d7 = Math.sqrt((d - d2) * (d - d2) + 4.0 * d3 * d4);
        double d8 = 0.5 * (d + d2 + d7);
        double d9 = 0.5 * (d + d2 - d7);
        this.fp = Math.sqrt(d8);
        this.fm = Math.sqrt(d9);
        this.aa1 = (d9 - d) / (d9 - d8);
        this.ba1 = -(d8 - d) / (d9 - d8);
        this.ab1 = (d8 - d) * this.aa1 / d3;
        this.bb1 = (d9 - d) * this.ba1 / d3;
    }

    private void reInitB(double d) {
        this.f0 = Math.PI * 2 * (this.f + d);
        double d2 = (-this.la * this.f0 * this.f0 + 1.0 / this.ca + 1.0 / this.cc) * this.cc;
        double d3 = this.ra * this.f0 * this.cc;
        double d4 = (-this.lb * this.f0 * this.f0 + 1.0 / this.cb + 1.0 / this.cc) * this.cc;
        double d5 = this.rb * this.f0 * this.cc;
        double d6 = 1.0 - d2 * d4 + d3 * d5;
        double d7 = -d2 * d5 - d3 * d4;
        this.a2R = 1.0 + (d4 * d6 + d5 * d7) * this.cc / ((d6 * d6 + d7 * d7) * this.ca);
        this.b2R = -this.cc * d6 / ((d6 * d6 + d7 * d7) * this.cb);
        this.a2I = (d5 * d6 - d4 * d7) * this.cc / ((d6 * d6 + d7 * d7) * this.ca);
        this.b2I = this.cc * d7 / ((d6 * d6 + d7 * d7) * this.cb);
        this.a2R *= this.s2;
        this.b2R *= this.s2;
        this.a2I *= this.s2;
        this.b2I *= this.s2;
    }

    void setCa(double d) {
        this.ca = d;
        if (this.ca < 1.0E-10) {
            this.ca = 1.0E-10;
        }
        this.reInit();
        this.repaint();
    }

    void setCc(double d) {
        this.cc = d;
        if (this.cc < 1.0E-10) {
            this.cc = 1.0E-10;
        }
        this.reInit();
        this.repaint();
    }

    void setF(double d) {
        this.f = d;
        if (this.f < 100.0) {
            this.f = 100.0;
        }
        this.reInit();
        this.repaint();
    }

    void setExperiment(int n) {
        this.f = this.indToF(900);
        this.knobF.setValue(900);
        this.ca = this.valCa[12];
        this.knobCa.setValue(12);
        this.cb = 3.3E-10;
        this.cc = this.valCc[6];
        this.knobCc.setValue(6);
        this.la = 0.01;
        this.lb = 0.01;
        this.ra = 13.0;
        this.rb = 10.0;
        if (n == 1 || n == 2 || n == 3) {
            this.experiment = n;
        } else {
            System.err.println("Experiment index must be 1 or 2");
        }
        if (this.experiment == 1) {
            this.knobF.disable();
        } else {
            this.knobF.enable();
        }
        this.reInit();
        this.repaint();
    }

    public double[] probeA(double d, double d2) {
        double[] dArray = new double[2];
        dArray = this.experiment == 1 ? this.getAmp1(this.aa1, this.ba1, d, d2) : (this.experiment == 2 ? this.getAmp2(this.a2R, this.a2I, d, d2) : this.getAmp3(this.a2R, this.a2I, d, d2));
        return dArray;
    }

    public double[] probeB(double d, double d2) {
        double[] dArray = new double[2];
        dArray = this.experiment == 1 ? this.getAmp1(this.ab1, this.bb1, d, d2) : (this.experiment == 2 ? this.getAmp2(this.b2R, this.b2I, d, d2) : this.getAmp3(this.b2R, this.b2I, d, d2));
        return dArray;
    }

    double[] getAmp1(double d, double d2, double d3, double d4) {
        double[] dArray = new double[2];
        if (d4 * this.fp < Math.PI && d4 * this.fm < Math.PI) {
            double d5 = Math.sin(this.fp * d3);
            double d6 = Math.sin(this.fm * d3);
            double d7 = Math.exp(-500.0 * d3);
            dArray[0] = (d * d5 + d2 * d6) * d7;
            dArray[1] = dArray[0];
        } else if (d4 * Math.abs(this.fp - this.fm) < Math.PI * 2) {
            double d8 = Math.cos((this.fp - this.fm) * d3 / 2.0);
            double d9 = Math.sin((this.fp - this.fm) * d3 / 2.0);
            double d10 = Math.exp(-500.0 * d3);
            dArray[1] = (Math.abs((d + d2) * d8) + Math.abs((d - d2) * d9)) * d10;
            dArray[0] = -dArray[1];
        } else {
            double d11 = Math.exp(-500.0 * d3);
            dArray[1] = (Math.abs(d) + Math.abs(d2)) * d11;
            dArray[0] = -dArray[1];
        }
        return dArray;
    }

    double[] getAmp2(double d, double d2, double d3, double d4) {
        double[] dArray = new double[2];
        if (d4 * this.f0 < Math.PI) {
            double d5 = Math.cos(this.f0 * d3);
            double d6 = Math.sin(this.f0 * d3);
            dArray[0] = d * d5 - d2 * d6;
            dArray[1] = dArray[0];
        } else {
            dArray[1] = Math.sqrt(d * d + d2 * d2);
            dArray[0] = -dArray[1];
        }
        return dArray;
    }

    double[] getAmp3(double d, double d2, double d3, double d4) {
        double[] dArray = new double[2];
        this.reInitB(10000.0 * d3);
        dArray[1] = Math.sqrt(d * d + d2 * d2);
        dArray[0] = -dArray[1];
        return dArray;
    }
}

