/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;

public class SliderField
extends Panel {
    TextField text;
    Slider slider;
    double val;
    double valDef;
    double valMin;
    double valMax;
    boolean log;
    int sval;
    int svalMax = 100;
    int svalStp = 2;
    String tval;

    SliderField(double d, double d2, double d3, boolean bl) {
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        this.val = d;
        this.valDef = d;
        this.valMin = d2;
        this.valMax = d3;
        this.log = bl;
        this.setForeground(Color.black);
        this.text = new TextField(6);
        this.slider = new Slider(0, this.svalMax, 16);
        this.updateText();
        this.updateSlider();
        this.setLayout(new FlowLayout(0, 0, 2));
        this.add(this.text);
        this.add(new Label(" "));
        this.add(this.slider);
        Dimension dimension = this.text.minimumSize();
        System.out.println(dimension);
    }

    public void setValue(double d) {
        if (d < this.valMin) {
            d = this.valMin;
        }
        if (d > this.valMax) {
            d = this.valMax;
        }
        this.val = d;
        this.updateText();
        this.updateSlider();
    }

    public double getValue() {
        String string = this.text.getText();
        if (!this.tval.equals(string)) {
            this.tval = string;
            this.checkText();
            this.updateSlider();
        }
        return this.val;
    }

    private void updateText() {
        this.tval = String.valueOf(this.val);
        ((TextComponent)this.text).setText(this.tval);
    }

    private void updateSlider() {
        this.sval = this.log ? (int)Math.round((double)this.svalMax * Math.log(this.val / this.valMin) / Math.log(this.valMax / this.valMin)) : (int)Math.round((double)this.svalMax * (this.val - this.valMin) / (this.valMax - this.valMin));
        this.slider.setValue(this.sval);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 1001: {
                if (event.target == this.text) {
                    this.tval = this.text.getText();
                    this.checkText();
                    this.updateSlider();
                    this.signalParent();
                    return true;
                }
                if (event.target != this.slider) break;
                this.sval = this.slider.getValue();
                this.val = (double)this.sval / (double)this.svalMax;
                if (this.log) {
                    this.val *= Math.log(this.valMax / this.valMin);
                    this.val = this.valMin * Math.exp(this.val);
                } else {
                    this.val = this.valMin + this.val * (this.valMax - this.valMin);
                }
                this.val = this.round(this.val);
                this.updateText();
                this.signalParent();
                return true;
            }
        }
        return false;
    }

    private void checkText() {
        try {
            this.val = Double.valueOf(this.tval);
        }
        catch (NumberFormatException numberFormatException) {
            this.val = this.valDef;
            this.updateText();
        }
        if (this.val < this.valMin) {
            this.val = this.valMin;
            this.updateText();
            return;
        }
        if (this.val > this.valMax) {
            this.val = this.valMax;
            this.updateText();
        }
    }

    private void signalParent() {
        Event event = new Event(this, 1001, this);
        this.getParent().postEvent(event);
    }

    private double round(double d) {
        double d2 = 100.0;
        int n = 1;
        if (d == 0.0) {
            return 0.0;
        }
        if (d < 0.0) {
            n = -1;
            d = -d;
        }
        double d3 = d;
        while (d3 < 1.0) {
            d3 *= 10.0;
            d2 *= 10.0;
        }
        while (d3 >= 10.0) {
            d3 /= 10.0;
            d2 /= 10.0;
        }
        d = (double)Math.round(d * d2) / d2;
        return (double)n * d;
    }
}

