/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public class Control199812
extends Panel {
    SliderField load = new SliderField(this.loadDef, this.loadMin, this.loadMax, true);
    SliderField voltage = new SliderField(this.voltageDef, this.voltageMin, this.voltageMax, false);
    Choice wire = new Choice();
    SliderField length = new SliderField(this.lengthDef, this.lengthMin, this.lengthMax, false);
    Label lead1Res;
    Label lead2Res;
    Label totalRes;
    Label loadCurrent;
    Label netVoltage;
    double loadMin = 0.1;
    double loadMax = 50.0;
    double loadDef = 1.0;
    double voltageMin;
    double voltageMax = 100.0;
    double voltageDef = 20.0;
    double lengthMin = 1.0;
    double lengthMax = 10.0;
    double lengthDef = 2.5;
    double lead1ResVal;
    double lead2ResVal;
    double totalResVal;
    double loadCurrentVal;
    double netVoltageVal;

    Control199812() {
        this.wire.addItem("10");
        this.wire.addItem("12");
        this.wire.addItem("14");
        this.wire.addItem("16");
        this.wire.addItem("18");
        this.wire.addItem("20");
        this.wire.addItem("22");
        this.wire.select("14");
        this.lead1Res = new Label();
        this.lead2Res = new Label();
        this.totalRes = new Label();
        this.loadCurrent = new Label();
        this.netVoltage = new Label();
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(9, 2));
        this.setForeground(Color.darkGray);
        panel.add(new Label("Load resistance (in ohms):"));
        panel.add(this.load);
        panel.add(new Label("Supply voltage at output(in V):"));
        panel.add(this.voltage);
        panel.add(new Label("AWG wire size:"));
        panel.add(this.wire);
        panel.add(new Label("Length of of one lead (in ft):"));
        panel.add(this.length);
        panel.add(new Label("Lead resistance, one lead (in ohms):"));
        panel.add(this.lead1Res);
        panel.add(new Label("Lead resistance, both leads (in ohms):"));
        panel.add(this.lead2Res);
        panel.add(new Label("Total resistance, load + leads (in ohms):"));
        panel.add(this.totalRes);
        panel.add(new Label("Load current (in A):"));
        panel.add(this.loadCurrent);
        panel.add(new Label("Net voltage at load (in V):"));
        panel.add(this.netVoltage);
        this.add(panel);
    }

    public void start() {
        this.updateResults();
    }

    public void updateResults() {
        double d = this.getResCoeff();
        this.lead1ResVal = this.length.getValue() * d;
        this.lead2ResVal = 2.0 * this.lead1ResVal;
        this.totalResVal = this.load.getValue() + this.lead2ResVal;
        this.loadCurrentVal = this.voltage.getValue() / this.totalResVal;
        if (this.loadCurrentVal > 50.0) {
            this.loadCurrentVal = 50.0;
            this.voltage.setValue(this.totalResVal * this.loadCurrentVal);
        }
        this.netVoltageVal = this.loadCurrentVal * this.load.getValue();
        this.lead1Res.setText(String.valueOf(this.round(this.lead1ResVal)));
        this.lead2Res.setText(String.valueOf(this.round(this.lead2ResVal)));
        this.totalRes.setText(String.valueOf(this.round(this.totalResVal)));
        this.loadCurrent.setText(String.valueOf(this.round(this.loadCurrentVal)));
        this.netVoltage.setText(String.valueOf(this.round(this.netVoltageVal)));
    }

    private double getResCoeff() {
        String string = this.wire.getSelectedItem();
        if (string.equals("10")) {
            return 9.99E-4;
        }
        if (string.equals("12")) {
            return 0.00159;
        }
        if (string.equals("14")) {
            return 0.00253;
        }
        if (string.equals("16")) {
            return 0.00402;
        }
        if (string.equals("18")) {
            return 0.00639;
        }
        if (string.equals("20")) {
            return 0.0102;
        }
        if (string.equals("22")) {
            return 0.0161;
        }
        return 0.0;
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.load || event.target == this.voltage || event.target == this.wire || event.target == this.length) {
            this.updateResults();
            return true;
        }
        return false;
    }

    private double round(double d) {
        double d2 = 100.0;
        int n = 1;
        if (d == 0.0) {
            return 0.0;
        }
        if (d < 0.0) {
            n = -1;
            d = -d;
        }
        double d3 = d;
        while (d3 < 1.0) {
            d3 *= 10.0;
            d2 *= 10.0;
        }
        while (d3 >= 10.0) {
            d3 /= 10.0;
            d2 /= 10.0;
        }
        d = (double)Math.round(d * d2) / d2;
        return (double)n * d;
    }
}

