/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;

public class Slider
extends Canvas {
    int borderWidth = 4;
    int borderHeight = 2;
    int width = 10;
    int height = 100 + 2 * this.borderWidth;
    int range;
    int val;
    boolean adjusting = false;

    Slider(int n, int n2, int n3) {
        this.val = n;
        this.range = n2;
        this.width = n2 + 2 * this.borderWidth;
        this.height = n3 + 2 * this.borderHeight;
        this.repaint();
    }

    public void setValue(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.range) {
            n = this.range;
        }
        this.val = n;
        this.repaint();
    }

    public int getValue() {
        return this.val;
    }

    public Dimension preferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension minimumSize() {
        return new Dimension(this.width, this.height);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.gray);
        int n = this.borderWidth;
        int n2 = this.width - this.borderWidth;
        int n3 = this.height - this.borderHeight;
        int n4 = this.borderHeight;
        graphics.drawLine(n, n3, n, n4);
        graphics.drawLine(n, n3, n2, n4);
        graphics.drawLine(n2, n3, n2, n4);
        graphics.setColor(Color.red);
        n = n2 = this.val + this.borderWidth;
        n3 = this.borderHeight;
        n4 = this.height - this.borderHeight;
        graphics.drawLine(n, n3, n2, n4);
        graphics.setColor(Color.red.brighter());
        n = n2 = this.val + this.borderWidth - 1;
        graphics.drawLine(n, n3, n2, n4);
        graphics.setColor(Color.red.darker());
        n = n2 = this.val + this.borderWidth + 1;
        graphics.drawLine(n, n3, n2, n4);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (n >= 0 && n <= this.width && n2 >= 0 && n2 <= this.height) {
            this.adjusting = true;
            this.setValue(n - this.borderWidth);
            return true;
        }
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.adjusting) {
            this.setValue(n - this.borderWidth);
            return true;
        }
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.adjusting) {
            this.setValue(n - this.borderWidth);
            this.adjusting = false;
            Event event2 = new Event(this, 1001, this);
            this.getParent().postEvent(event2);
            return true;
        }
        return false;
    }
}

