/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;

public class Display
extends Canvas {
    int width;
    int height;
    Image offScrImg;
    double vMax;
    double iMax;
    double r;
    int xMin;
    int xMax;
    int yMin;
    int yMax;

    Display(int n, int n2) {
        this.width = n > 0 ? n : 100;
        this.height = n2 > 0 ? n2 : 100;
        this.xMin = (int)(0.15 * (double)n);
        this.xMax = (int)(0.8 * (double)n);
        this.yMin = (int)(0.2 * (double)n2);
        this.yMax = (int)(0.85 * (double)n2);
        this.iMax = 1.0;
        this.vMax = 1.0;
        this.r = 10000.0;
    }

    public void update(Graphics graphics) {
        if (this.offScrImg == null) {
            this.offScrImg = this.createImage(this.width + 1, this.height + 1);
        }
        Graphics graphics2 = this.offScrImg.getGraphics();
        graphics2.setColor(graphics.getColor());
        graphics2.setFont(graphics.getFont());
        this.paint(graphics2);
        graphics2.dispose();
        graphics.drawImage(this.offScrImg, 0, 0, this);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.width + 1, this.height + 1);
        graphics.setColor(Color.darkGray);
        graphics.drawRect(this.xMin, this.yMin, this.xMax - this.xMin, this.yMax - this.yMin);
        int n = this.xMin;
        int n2 = this.yMin - 20;
        graphics.drawLine(this.xMin, this.yMin, n, n2);
        graphics.drawLine(n, n2, n - 5, n2 + 5);
        graphics.drawLine(n, n2, n + 5, n2 + 5);
        n = this.drawText(graphics, "V out", n, n2, 0, 2);
        n = this.xMax + 20;
        n2 = this.yMax;
        graphics.drawLine(this.xMax, this.yMax, n, n2);
        graphics.drawLine(n, n2, n - 5, n2 - 5);
        graphics.drawLine(n, n2, n - 5, n2 + 5);
        n = this.drawText(graphics, "I out", n, n2, -2, 0);
        graphics.setColor(Color.darkGray);
        n = this.drawText(graphics, "V max", this.xMin, this.yMin, 2, 0);
        n = this.drawText(graphics, "I max", this.xMax, this.yMax, 0, -2);
        graphics.setColor(Color.blue);
        n = this.r > this.vMax / this.iMax ? this.drawText(graphics, "Constant Voltage mode", this.xMax, this.yMin, 1, 2) : this.drawText(graphics, "Constant Current mode", this.xMax, this.yMin, 1, 2);
        graphics.setColor(Color.blue);
        n2 = (int)((double)this.yMax - this.vMax * (double)(this.yMax - this.yMin));
        n = this.drawText(graphics, "V set", this.xMin, n2, 2, 0);
        graphics.drawLine(this.xMin, n2, this.xMax, n2);
        n = (int)((double)this.xMin + this.iMax * (double)(this.xMax - this.xMin));
        graphics.drawLine(n, this.yMin, n, this.yMax);
        n = this.drawText(graphics, "I set", n, this.yMax, 0, -2);
        graphics.setColor(Color.red);
        if (this.r > this.vMax / this.iMax) {
            n = (int)((double)this.xMin + this.vMax / this.r * (double)(this.xMax - this.xMin));
            n2 = (int)((double)this.yMax - this.vMax * (double)(this.yMax - this.yMin));
            this.drawText(graphics, "RL > RC", (this.xMin + n) / 2 + 5, (this.yMax + n2) / 2, -1, -1);
        } else {
            n = (int)((double)this.xMin + this.iMax * (double)(this.xMax - this.xMin));
            n2 = (int)((double)this.yMax - this.iMax * this.r * (double)(this.yMax - this.yMin));
            if (this.r == this.vMax / this.iMax) {
                this.drawText(graphics, "RL = RC", (this.xMin + n) / 2, (this.yMax + n2) / 2 - 5, 1, 1);
            } else {
                this.drawText(graphics, "RL < RC", (this.xMin + n) / 2, (this.yMax + n2) / 2 - 5, 1, 1);
            }
        }
        graphics.setColor(Color.red);
        graphics.drawLine(this.xMin, this.yMax, n, n2);
        graphics.fillOval(n - 5, n2 - 5, 10, 10);
        graphics.setColor(Color.red);
        if (this.r > this.vMax / this.iMax) {
            n = this.drawText(graphics, "1", n, n2 - 5, 1, 1);
            return;
        }
        n = this.drawText(graphics, "2", n + 5, n2, -1, -1);
    }

    private void drawBorder(Graphics graphics) {
        int n = 3;
        boolean bl = true;
        if (bl) {
            graphics.setColor(Color.darkGray);
        } else {
            graphics.setColor(Color.gray);
        }
        int n2 = 0;
        while (n2 < n) {
            graphics.drawLine(n2, n2, n2, this.height - n2);
            graphics.drawLine(n2, n2, this.width - n2, n2);
            ++n2;
        }
        if (!bl) {
            graphics.setColor(Color.darkGray);
        } else {
            graphics.setColor(Color.gray);
        }
        n2 = 0;
        while (n2 < n) {
            graphics.drawLine(this.width - n2, n2, this.width - n2, this.height - n2);
            graphics.drawLine(n2, this.height - n2, this.width - n2, this.height - n2);
            ++n2;
        }
    }

    public Dimension preferredSize() {
        return new Dimension(this.width + 1, this.height + 1);
    }

    public Dimension minimumSize() {
        return new Dimension(this.width + 1, this.height + 1);
    }

    public Insets insets() {
        return new Insets(20, 20, 20, 20);
    }

    public void setVMax(double d) {
        this.vMax = d;
    }

    public double getVMax() {
        return this.vMax;
    }

    public void setIMax(double d) {
        this.iMax = d;
    }

    public double getIMax() {
        return this.iMax;
    }

    public void setR(double d) {
        this.r = Math.tan(d * Math.PI / 2.0);
    }

    public double getR() {
        return this.r;
    }

    int drawText(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = fontMetrics.stringWidth("0");
        int n7 = fontMetrics.getAscent();
        int n8 = (int)(0.65 * (double)n7);
        if (n3 < 0) {
            n -= n6;
        }
        if (n3 == 0) {
            n -= n5 / 2;
        } else if (n3 > 0) {
            n -= n5;
            n += n6;
        }
        graphics.drawString(string, n -= n3 * n6, n2 += (int)(0.5 * (double)n7 - (double)(n4 * n8)));
        return n + n5;
    }
}

