/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public class Control
extends Panel {
    Display display;
    Slider resistance;
    Slider vMax;
    Slider iMax;

    Control(Display display) {
        this.display = display;
        this.resistance = new Slider(67, 100, 16);
        this.vMax = new Slider(50, 100, 16);
        this.iMax = new Slider(80, 100, 16);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(6, 1));
        panel.add(new Label("Voltage (V) Setting:"));
        panel.add(this.vMax);
        panel.add(new Label("Current (I) Setting:"));
        panel.add(this.iMax);
        panel.add(new Label("Load Resistance (RL):"));
        panel.add(this.resistance);
        this.add(panel);
    }

    public void start() {
        double d = (double)this.resistance.getValue() / 100.0;
        this.display.setR(d);
        d = (double)this.vMax.getValue() / 100.0;
        this.display.setVMax(d);
        d = (double)this.iMax.getValue() / 100.0;
        this.display.setIMax(d);
        this.display.repaint();
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 1001: {
                if (event.target == this.resistance) {
                    double d = (double)this.resistance.getValue() / 100.0;
                    this.display.setR(d);
                    this.display.repaint();
                    return true;
                }
                if (event.target == this.vMax) {
                    double d = (double)this.vMax.getValue() / 100.0;
                    this.display.setVMax(d);
                    this.display.repaint();
                    return true;
                }
                if (event.target != this.iMax) break;
                double d = (double)this.iMax.getValue() / 100.0;
                this.display.setIMax(d);
                this.display.repaint();
                return true;
            }
        }
        return false;
    }
}

